/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is AK7371
#ifndef __VCM_AK7371__
#define __VCM_AK7371__

#define AK7371_DEFAULT_POS          0x200
#define AK7371_MIN_FOCUS_POS        0
#define AK7371_MAX_FOCUS_POS        0x3FF
#define AK7371_HOME_FOCUS_POS       AK7371_DEFAULT_POS
#define AK7371_VCM_RUN_STEPS        32
#define AK7371_VCM_RESET_DELAY      1
#define AK7371_VCM_CODE_MSB         0x00
#define AK7371_VCM_CODE_LSB         0x01


NTSTATUS AK7371_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS AK7371_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS AK7371_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS AK7371_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS AK7371_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status
    );

NTSTATUS AK7371_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status
    );

NTSTATUS AK7371_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA *pSnsrVcmData
    );

#endif __VCM_AK7371__
