/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
#ifndef _NVRAM_H_
#define _NVRAM_H_

#include "nvram_type.h"

#define RESERVED_ARG 0xA0A
#define SPB_WRITE_TRANSFERS      1
#if defined(__MOCK_L1__) || !defined(STATE_SEPARATION_SUPPORT)
#define NVM_FILE_NAME       L"\\SystemRoot\\System32\\drivers\\IMX351_NVM.bin"
#else
#define NVM_FILE_NAME       L"IMX351_NVM.bin"
#define NVM_DUMP_PATH   L"\\DriverData\\Intel\\Camera\\NVMDump"
#endif
#define MAJORVER    0x00            //Calibration data major version;
#define MINORVER    0x01            //Calibration data minor version;
#define PDAFDATA    0x21E            //PDAF Calibration Present  0x01:valid   0x00:invalid or empty
#define IA_NVM_INTERFACE_NOPDAF_MAJOR_VERSION   1   //No PADF Calibration data Major Version;

typedef struct ROM_PAGE_ST_
{
     UINT8 adr;
     INT32 len;
     BOOLEAN flg;
} ROM_PAGE_ST;

typedef struct ROM_PAGEEX_ST_
{
     UINT16 adr;
     INT32 len;
     BOOLEAN flg;
} ROM_PAGEEX_ST;

typedef struct __NVM_FUNC_
{
    NVM_TYPE Type;
    LONG  Size;
    LONG  PageSize;
    ULONG StartAddr;
    SNSR_EEPROM NvmWrite;
    SNSR_EEPROM NvmRead;
    SNSR_GET_DATA GetNvmData;
} NVM_FUNC;

extern NVM_FUNC Nvm[];

/*! "brief ParseNvram
 *    parser nvram
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 *    UINT8 Type - nvram type
 *    UINT8 DefineInfoBios - nvram define in bios
 *    UINT8 Page - page number
 *    UINT16 Size - size of nvram
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS ParseNvram(
    PNVM_CONTEXT pSsNvm,
    UINT8 Type,
    UINT8 DefineInfoBios,
    UINT8 Page,
    UINT16 Size
    );

/*! "brief InitContextNvram
 *    init nvram context
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 * Return:
 *    NTSTATUS - status
 */
void InitContextNvram(
    PNVM_CONTEXT pDevExt
    );

/*! "brief Cmd_OtpWrite
 *    otp write
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 *    UINT16 Addr - addr of otp space
 *    UINT8* pData - data buffer pointer
 *    INT32 Length - data length
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS Cmd_OtpWrite(
    PNVM_CONTEXT pSsNvm,
    UINT16 Addr,
    UINT8* pData,
    INT32 Length
    );

/*! "brief Cmd_OtpRead
 *    otp read
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 *    UINT16 Addr - addr of otp space
 *    UINT8* pData - data buffer pointer
 *    INT32 Length - data length
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS Cmd_OtpRead(
    PNVM_CONTEXT pSsNvm,
    UINT16 Addr,
    UINT8* pData,
    INT32 Length
    );

/*! "brief InitOtp
 *    otp read
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS InitOtp(
    PNVM_CONTEXT pSsNvm
    );

/*! "brief GetNvmData
 *    nvram data read
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 *    PULONG Size - size to get
 *    PUINT8 Buffer - data buffer
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS GetNvmData(
    PNVM_CONTEXT pSsNvm,
    PULONG Size,
    PUINT8 Buffer
    );

/*! "brief GetNvmData
 *    nvram data dump
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 *    PULONG Size - size to get
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS
DumpNVM(
    PNVM_CONTEXT pSsNvm,
    ULONG Size
);

#if !defined(__MOCK_L1__) && defined(STATE_SEPARATION_SUPPORT)
//create nvm dump dir \DriverData\Intel\Camera\NVMDump
BOOLEAN CreateNVMDumpDir();
#endif

#ifdef SKY_CAM
/*! "brief PreProcessNVM
 *    pre process NVRAM
 *
 * Arg:
 *    PDEVICE_CONTEXT SensorCtx - context pointer of nvram
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS PreProcessNVM(
    PDEVICE_CONTEXT SensorCtx
    );
#endif

/*! "brief TraceLogNvm
*    print log info
*
* Arg:
*    PNVM_CONTEXT pSsNvm - context pointer of nvram
*    const char *str - string info
*    unsigned int arg0 - data/ptr, can fill with default RESERVED_ARG.
*    unsigned int arg1 - data/ptr, can fill with default RESERVED_ARG.
* Return:
*    NTSTATUS - status
*/
void TraceLogNvm(
    PNVM_CONTEXT pSsNvm,
    const char *str,
    unsigned int arg0,
    unsigned int arg1);
#endif

