/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef __SS_VCM_H__
#define __SS_VCM_H__

#include "SsI2c.h"
#include "vcm_type.h"
#include "sensor_intf.h"

typedef enum
{
    OPEN_LOOP_MODE = 0,
    DIRECT_MOVE_MODE,
    STEP_MOVE_MODE,
} VCM_MODE;

/*! "brief VCM_CONTEXT
 *    vcm context data structure
 */
typedef struct __VCM_CONTEXT_
{
    WDFDEVICE       DevHandle;                      /*! Global. Sensor device handle*/
    const char*     DevName;                        /*! Global. Sensor device name*/
    KEVENT*         pSettingEvent;                  /*! Global. Sensor i2c resgiter mutex*/
    PI2C_CONTEXT    pI2cDev;                        /*! Global. Sensor i2c context pointer*/

    SHORT           Focus;                          /*! focus value*/
    INT32           FocusSteps;                     /*! focus steps value*/
    LARGE_INTEGER   FocusTimeStamp;                 /*! focus time stamp*/
    VCM_TYPE        VcmType;                        /*! vcm type*/
    UINT16          VCMHomePostion;                 /*! vcm home position*/
    UINT16          VCMFarPosition;                 /*! vcm far position*/
    UINT8           VCMMode;                        /*! vcm supports closed loop or not*/
    UINT8          Hall_Offset;                      /*!< vertical distance b/w Hall sensor and Magnet */
    UINT8          Hall_Bias;                       /*!< horizontal distance b/w Hall sensor and Magnet */
    SNSR_SET_FOCUS_POS         SetFocusPos;         /*!< Mandatory. Function to set vcm focus position. */
    SNSR_GET_FOCUS_POS         GetFocusPos;         /*!< Mandatory. Function to get vcm focus position. */
    SNSR_GET_FOCUS_STATUS      GetFocusStatus;      /*!< Mandatory. Function to get vcm focus status. */
    SNSR_GET_FOCUS_HP_STATUS   GetFocusHPStatus;    /*!< Mandatory. Function to get vcm focus home position status. */
    SNSR_SET_VCM_CONFIGURATION SetVcmConfiguration; /*!< Mandatory. Function to set vcm init configuration. */
} VCM_CONTEXT, *PVCM_CONTEXT;

/*! "brief SsVcmZeroInit
 *    vcm initialization in zero status
 *
 * Arg:
 *    PVCM_CONTEXT pSsVcm - context pointer of nvram
 *    WDFDEVICE hDevice - sensor device handle
 *    const char* DeviceName - sensor device name
 *    KEVENT* pEvent - mutex to sync i2c register accessing
 *    PI2C_CONTEXT pI2cContext - i2c context pointer
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS SsVcmZeroInit(
    OUT PVCM_CONTEXT pSsVcm,
    IN WDFDEVICE hDevice,
    IN const char* DeviceName,
    IN KEVENT* pEvent,
    IN PI2C_CONTEXT pI2cContext
    );

#endif
