/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef _SS_GPIO_H_
#define _SS_GPIO_H_

#include "dsdt.h"

/*! "brief GPIO_RESOURCE
 *    data structure of gpio resource
 */
typedef struct _GPIO_RESOURCE_
{
    LARGE_INTEGER           ConnectionId; /*! gpio wdf connection id*/
    WDFIOTARGET             Target;       /*! gpio wdf target*/
    WDFREQUEST              Request;      /*! gpio wdf request*/
    UINT8                   ActiveLevel;  /*! gpio active level (0-low, 1 high)*/
    UINT8                   Value;        /*! gpio value to set*/
    UINT8                   Flag;         /*! gpio supported*/
} GPIO_RESOURCE, *PGPIO_RESOURCE;

/*! "brief GPIO_CONTEXT
 *    data structure of gpio context
 */
typedef struct _GPIO_CONTEXT_
{
    WDFDEVICE     DevHandle;              /*! sensor device handle*/
    const char*   DevName;                /*! sensor device name*/
    GPIO_RESOURCE Gpio[GPIO_NUM];         /*! gpio resource table*/
} GPIO_CONTEXT, *PGPIO_CONTEXT;

extern const char* GPIO_STRING[];

/*! "brief SsGpioZeroInit
 *    Gpio context init with zero status
 *
 * Arg:
 *    PGPIO_CONTEXT pGpioDev - context pointer of gpio
 *    WDFDEVICE hDevice - sensor device handle
 *    const char* DeviceName - sensor device name
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS SsGpioZeroInit(
    OUT PGPIO_CONTEXT pGpioDev,
    IN WDFDEVICE hDevice,
    IN const char* DeviceName
    );

/*! "brief SsGpioPinsInit
 *    Gpio pins intialization
 *
 * Arg:
 *    PGPIO_CONTEXT pGpioDev - context pointer of gpio
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS SsGpioPinsInit(
    IN PGPIO_CONTEXT pDevExt
    );

/*! "brief SsGpioPinsUninit
 *    Gpio pins un-intialization
 *
 * Arg:
 *    PGPIO_CONTEXT pGpioDev - context pointer of gpio
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS SsGpioPinsUninit(
    IN PGPIO_CONTEXT pDevExt
    );

/*! "brief SsGpioPinSet
 *    Gpio context init with zero status
 *
 * Arg:
 *    PGPIO_CONTEXT pGpioDev - context pointer of gpio
 *    ULONG Index - gpio pin index
 *    UINT8 Flag - status of pin to set (0-low, 1-high)
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS SsGpioPinSet(
    PGPIO_CONTEXT pDevExt,
    ULONG Index,
    UINT8 Flag
    );

#endif
