/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/
#ifndef _VCM_TYPE_H__
#define _VCM_TYPE_H__

/*! "brief
 *    enum of vcm type
 */
#define NONVCM_NAME         "NoneVCM"
#define DW9714_NAME         "DW9714"
#define AD5823_NAME         "AD5823"
#define DW9718_NAME         "DW9718"
#define AD5816_NAME         "AD5816"
#define DW9719_NAME         "DW9719"
#define DW9806B_NAME        "DW9806B"
#define WV517S_NAME         "WV517S"
#define LC898122XA_NAME     "LC898122XA"
#define LC898212AXB_NAME    "LC898212AXB"
#define AK7371_NAME         "AK7371"
#define BU64297GWZ_NAME     "BU64297GWZ"
#define DW9800_NAME         "DW9800"
//#define VCM_ex1           "VCM_ex1_NAME"

#define VCM_DELAY_TAG        0xFF

/*! "brief VCM_TYPE
 *    enum of vcm type
 */
typedef enum _VCM_YPE__
{
    VCM_NONE,
    VCM_AD5823,
    VCM_DW9714,
    VCM_AD5816,
    VCM_DW9719,
    VCM_DW9718,
    VCM_DW9806B,
    VCM_WV517S,
    VCM_LC898122XA,
    VCM_LC898212AXB,

    // below defines are for outside DDK use, don't remove or change in our project
    // "VCM_ex1" place holder, change to real name when needed
    VCM_ex1,
    VCM_ex2,
    VCM_ex3,
    VCM_ex4,
    VCM_ex5,

    // New VCM added to last in case to change above reserved values being used externally
    VCM_AK7371,
    VCM_BU64297GWZ,
    VCM_DW9800,         // 17
    VCM_NUM
} VCM_TYPE;

/*! "brief VCM_COMMON_FUNC
 *    type of function for vcm
 */
typedef NTSTATUS (* VCM_COMMON_FUNC)(
    PVOID Context
    );

#endif
