/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is LC898122XA
#ifndef __VCM_LC898122XA__
#define __VCM_LC898122XA__

#define LC898122XA_DEFAULT_POS          0x400
#define LC898122XA_MIN_FOCUS_POS        0    
#define LC898122XA_MAX_FOCUS_POS        0x7FF 
#define LC898122XA_HOME_FOCUS_POS       LC898122XA_DEFAULT_POS
#define LC898122XA_VCM_RUN_STEPS        32
#define LC898122XA_VCM_RESET_DELAY      1
#define LC898122XA_VCM_CODE_MSB         0x0380
#define LC898122XA_VCM_CODE_LSB         0x0381
#define LC898122XA_VCM_STATUS           0x0335


NTSTATUS LC898122XA_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS LC898122XA_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS LC898122XA_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS LC898122XA_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS LC898122XA_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS LC898122XA_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status    
    );

NTSTATUS LC898122XA_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

#endif __VCM_LC898122XA__
