/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2018 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The VCM is DW9800
#ifndef __VCM_DW9800__
#define __VCM_DW9800__

#define DW9800_DEFAULT_POS     1
#define DW9800_MIN_FOCUS_POS        1    //150
#define DW9800_MAX_FOCUS_POS        1023 //350
#define DW9800_HOME_FOCUS_POS       DW9800_MIN_FOCUS_POS
#define DW9800_VCM_DOWN_STEPS       32
#define DW9800_VCM_WARMUP_STEPS     32
#define DW9800_VCM_UP_INERTIA       50
#define DW9800_VCM_DOWN_INERTIA     90
#define DW9800_VCM_DIST_FAR_HOME    140
#define DW9800_VCM_RESET_DELAY      10

#define DW9800_VCM_IC_INFO          0x00
#define DW9800_VCM_CODE_MSB         0x03
#define DW9800_VCM_CODE_LSB         0x04
#define DW9800_VCM_STATUS           0x05

extern S_SETTING DW9800VcmConfigration[];

NTSTATUS DW9800_Init(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9800_ResetPos(
    PVCM_CONTEXT pSsVcm
    );

NTSTATUS DW9800_SetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT FocusPos
    );

NTSTATUS DW9800_WarmStart(
    PVCM_CONTEXT pDevExt
    );

NTSTATUS DW9800_GetPos(
    PVCM_CONTEXT pSsVcm,
    USHORT *FocusPos
    );

NTSTATUS DW9800_GetStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status
    );

NTSTATUS DW9800_GetHPStatus(
    PVCM_CONTEXT pSsVcm,
    PULONG Status
    );

NTSTATUS DW9800_SetConfig(
    PVCM_CONTEXT pSsVcm,
    SNSR_VCMDATA* pSnsrVcmData
    );

NTSTATUS DW9800_Test(
    PVCM_CONTEXT pSsVcm
    );

#endif __VCM_DW9800__
