/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

// The EEPROM is CAT24C64

#ifndef __EEPROM_CAT24C64__
#define __EEPROM_CAT24C64__


#define CAT24C64_PAGE_SIZE  32
#define CAT24C64_PAGE_NUM   2048
#define CAT24C64_SIZE       (CAT24C64_PAGE_SIZE * CAT24C64_PAGE_NUM)
#define CAT24C64_ADDR_MIN   0
#define CAT24C64_ADDR_MAX   (CAT24C64_SIZE - 1)

NTSTATUS
Cmd_Cat24c64Write(
    PNVM_CONTEXT SensorCtx,
    UINT16 Addr,
    UINT8* pData,
    INT32 Length
    );

NTSTATUS
Cmd_Cat24c64Read(
    PNVM_CONTEXT SensorCtx,
    UINT16 Addr,
    UINT8* pData,
    INT32 Length
    );

#endif __EEPROM_CAT24C64__
