/*************************************************************************************************
// INTEL CONFIDENTIAL Copyright 2011-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to the source code
// ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
// and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
// protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
// Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual property right is
// granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under such intellectual property
// rights must be express and approved by Intel in writing.
//*************************************************************************************************/

#ifndef __SS_NVM_H__
#define __SS_NVM_H__

#include "SsI2c.h"
#include "nvram_type.h"
#include "sensor_intf.h"

/*! "brief EEPROM_VALID_SIZE
 *    valid size of eeprom/otp
 */

#ifndef EEPROM_VALID_SIZE
#define EEPROM_VALID_SIZE           (1024*3)
#endif

typedef NTSTATUS(*PreProcessNVMPtr)(PNVM_CONTEXT);

/*! "brief NVM_CONTEXT
 *    nvram context data structure
 */
typedef struct __NVM_CONTEXT_
{
    WDFDEVICE           DevHandle;                      /*! Global. Sensor device handle*/
    const char*         DevName;                        /*! Global. Sensor device name*/
    KEVENT*             pSettingEvent;                  /*! Global. Sensor i2c resgiter mutex*/
    PI2C_CONTEXT        pI2cDev;                        /*! Global. Sensor i2c context pointer*/
    PVOID               pDeviceCtx;                     /*! Global. Sensor device context*/
    BOOLEAN             IsLoadingStage;                 /*! Global. Sensor driver loading stage*/
    PreProcessNVMPtr    PreProcessNVM;                  /*! Global. NVM pre processing*/

    BOOLEAN             ReadNVMLoadingDriver;           /*! Flag if read nvram loading driver*/
    ULONG               NvmValidDataSize;               /*! NVM valid calibration data size*/
    UINT8               NvmIsBufferComplete;            /*! NVM buffer is complete or not*/
    NVM_TYPE            NvmType;                        /*! NVM type*/
    LONG                NvmSize;                        /*! NVM total size*/
    LONG                NvmPage;                        /*! NVM access page size*/
    UINT8               NvmBuffer[EEPROM_VALID_SIZE];   /*! NVM data buffer*/

    SNSR_EEPROM         SetEEPRom;                      /*!< Optional. Function to set eeprom. */
    SNSR_EEPROM         GetEEPRom;                      /*!< Mandatory. Function to get eeprom data. */
    SNSR_GET_DATA       GetCalibrationData;
} NVM_CONTEXT, *PNVM_CONTEXT;

/*! "brief SsNvmZeroInit
 *    nvram initialization in zero status
 *
 * Arg:
 *    PNVM_CONTEXT pSsNvm - context pointer of nvram
 *    WDFDEVICE hDevice - sensor device handle
 *    const char* DeviceName - sensor device name
 *    KEVENT* pEvent - mutex to sync i2c register accessing
 *    PI2C_CONTEXT pI2cContext - i2c context pointer
 *    ULONG* pDeviceContext - sensor device context
 * Return:
 *    NTSTATUS - status
 */
NTSTATUS SsNvmZeroInit(
    OUT PNVM_CONTEXT pSsNvm,
    IN WDFDEVICE hDevice,
    IN const char* DeviceName,
    IN KEVENT* pEvent,
    IN PI2C_CONTEXT pI2cContext,
    IN ULONG* pDeviceContext
    );

#endif

