/************************************************************************
//*                        INTEL CONFIDENTIAL                           *
//***********************************************************************
// Copyright 2015 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents
// related to the source code ("Material") are owned by Intel
// Corporation or its suppliers or licensors. Title to the Material
// remains with Intel Corporation or its suppliers and licensors.
// The Material may contain trade secrets and proprietary and
// confidential information of Intel Corporation and its suppliers and licensors,
// and is protected by worldwide copyright and trade secret
// laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted,
// transmitted, distributed, or disclosed in any way without Intels
// prior express written permission.
//
// No license under any patent, copyright, trade secret or other
// intellectual property right is granted to or conferred upon you by
// disclosure or delivery of the Materials, either expressly, by
// implication, inducement, estoppel or otherwise. Any license under
// such intellectual property rights must be express and approved by
// Intel in writing.

/** @file IvcamDriverInterface.h */

#pragma once

#include <wdm.h>

// {57221519-92F3-4DB5-A776-FDAEC79222F9}
static const GUID GUID_SCL_DRIVER_INTERFACE =
{ 0x57221519, 0x92f3, 0x4db5, { 0xa7, 0x76, 0xfd, 0xae, 0xc7, 0x92, 0x22, 0xf9 } };
static const int SCL_DRIVER_INTERFACE_VERSION = 1;


typedef enum _SCL_POWER
{ 
    SCL_POWER_ON, 
    SCL_POWER_SHORT_STANDBY,
    SCL_POWER_LONG_STANDBY, 
    SCL_POWER_OFF = 0xff 
} SCL_POWER;

typedef NTSTATUS(*SCL_SEND_I2CWRITE_COMMAND)(
    IN PVOID pSclContext,
    IN UINT16 i2cAddress,    //Address of I2C register
    IN UINT16 i2cDataLen,    //Defines Data length
    IN PUINT8 pI2cData       //Data buffer ,release by sender
    );

typedef NTSTATUS(*SCL_SEND_I2CREAD_COMMAND)(
    IN PVOID pSclContext,
    IN UINT16 i2cAddress,    //Address of I2C register
    IN UINT16 i2cDataLen,    //Defines Data length
   OUT PUINT8 pI2cData       //Data buffer ,release by sender
    );

#define SCL_I2C_BURST_CMD_ENTRY_MAX_BYTES (4)
typedef struct _SCL_I2C_BURST_CMD_ENTRY
{
    UINT16 numBytes;
    UINT16 i2cAddress;
    UINT8 data[SCL_I2C_BURST_CMD_ENTRY_MAX_BYTES];
}SCL_I2C_BURST_CMD_ENTRY, *PSCL_I2C_BURST_CMD_ENTRY;

typedef NTSTATUS(*SCL_SEND_I2C_BURST_COMMAND)(
    IN PVOID pSclContext,
    IN UINT32 numEntries, // Number of burst command entries.
    IN PSCL_I2C_BURST_CMD_ENTRY data // burst commands array.
    );

typedef NTSTATUS(*SCL_SEND_POWER_COMMAND)(
    IN PVOID pSclContext,
    IN SCL_POWER power    //Power command
    );

typedef NTSTATUS(*SCL_SEND_GET_CALIB_DATA_COMMAND)(
    IN PVOID  pSclContext,
    IN UINT16 dataOffset,    //Calibration data offset
    IN UINT16 dataLength,    //Calibration data length
   OUT PVOID  data           //Data buffer ,release by sender
    );

typedef void(*SCL_DRIVER_ERROR_CALLBACK)(
    PVOID pSensorContext
    );

typedef NTSTATUS(*SCL_DRIVER_REGISTER_ERROR_CALLBACK)(
    IN PVOID pSclContext,
    IN SCL_DRIVER_ERROR_CALLBACK clientCallback,
    IN PVOID clientContext
    );

typedef struct _SENSOR_CONTROL_LINK
{
    struct _INTERFACE Interface;
    SCL_DRIVER_REGISTER_ERROR_CALLBACK  RegisterErrorCb;
    SCL_SEND_I2CREAD_COMMAND            I2CRead;
    SCL_SEND_I2CWRITE_COMMAND           I2CWrite;
    SCL_SEND_I2C_BURST_COMMAND          I2CBurstWrite;
    SCL_SEND_POWER_COMMAND              SetPower;
    SCL_SEND_GET_CALIB_DATA_COMMAND     GetCalibrationData;
} SENSOR_CONTROL_LINK, *PSENSOR_CONTROL_LINK;
