::*************************************************************************************************
:: INTEL CONFIDENTIAL Copyright 2011-2016 Intel Corporation All Rights Reserved.
::
:: The source code contained or described herein and all documents related to the source code
:: ("Material") are owned by Intel Corporation or its suppliers or licensors. Title to the Material
:: remains with Intel Corporation or its suppliers and licensors. The Material contains trade secrets
:: and proprietary and confidential information of Intel or its suppliers and licensors. The Material is
:: protected by worldwide copyright and trade secret laws and treaty provisions. No part of the
:: Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted,
:: distributed, or disclosed in any way without Intel's prior express written permission.
::
:: No license under any patent, copyright, trade secret or other intellectual property right is
:: granted to or conferred upon you by disclosure or delivery of the Materials, either expressly, by
:: implication, inducement, estoppel or otherwise. Any license under such intellectual property
:: rights must be express and approved by Intel in writing.
::*************************************************************************************************/

@echo off
setlocal

set curdirectory=%~dp0
set CameraDDK_dir=CameraDDK
set Sensor_dir=Sensor
set Last_dir=..\
set BuildDir=%cd%

::DDK sensor path
set DdkSensorDir=%curdirectory%%Last_dir%%Sensor_dir%

::ov8858
set ov8858ProjFile=ov8858.vcxproj
set ov8858ProjFilePath=%DdkSensorDir%\ov8858

::hm2051
set hm2051ProjFile=hm2051.vcxproj
set hm2051ProjFilePath=%DdkSensorDir%\hm2051

::Sample
set SampleProjFile=Sample.vcxproj
set SampleProjFilePath=%DdkSensorDir%\Sample

set BuildType=

::compile define
set MsbuildTool=C:\Program Files (x86)\MSBuild\14.0\Bin\MSBuild.exe

if "%1" == "" (
    set "BuildType=ALL"
    goto build_all
) else if "%1" == "SKL" (
    set "BuildType=SKL"
    goto build_skl    
) else if "%1"=="CNL" (
    set "BuildType=CNL"
    goto build_cnl
) else (
    echo Parameter error..    
    echo BuildCameraSensor.bat SKL:    build SKL platform
    echo BuildCameraSensor.bat CNL:    build CNL platform
    exit /b
)


:build_all

:build_skl

set PLAT_FORM=SKYCAM
set INPUT_SYSTEM=SKY_CAM

if exist "%SampleProjFilePath%\%SampleProjFile%" (
rem    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Debug"   /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Debug"
    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Release" /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Release"
)

if "BuildType"=="ALL" (
    goto build_cnl
) else (
    goto build_end
)

:build_cnl
set PLAT_FORM=cnlB0

::build Sample
if exist "%SampleProjFilePath%\%SampleProjFile%" (
rem    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Debug"   /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Debug"
    "%MsbuildTool%" "%SampleProjFilePath%\%SampleProjFile%" /t:Build /p:Configuration="Release" /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Release"
)
goto build_end

::build ov8858
if exist "%ov8858ProjFilePath%\%ov8858ProjFile%" (
    "%MsbuildTool%" "%ov8858ProjFilePath%\%ov8858ProjFile%" /t:Build /p:Configuration="Debug"   /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Debug"
    "%MsbuildTool%" "%ov8858ProjFilePath%\%ov8858ProjFile%" /t:Build /p:Configuration="Release" /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Release"
)
::build hm2051
if exist "%hm2051ProjFilePath%\%hm2051ProjFile%" (
    "%MsbuildTool%" "%hm2051ProjFilePath%\%hm2051ProjFile%" /t:Build /p:Configuration="Debug"   /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Debug"
    "%MsbuildTool%" "%hm2051ProjFilePath%\%hm2051ProjFile%" /t:Build /p:Configuration="Release" /p:Platform="x64"   /p:OutDir=".\Bin\%PLAT_FORM%\x64\Release"
)

:build_end
::cd %BuildDir%
exit /b